/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.items.ItemBase;
import reliquary.items.util.IPotionItem;
import reliquary.reference.Settings;
import reliquary.util.potions.PotionEssence;
import reliquary.util.potions.PotionMap;
import reliquary.util.potions.XRPotionHelper;

public class PotionItemBase
extends ItemBase
implements IPotionItem {
    public PotionItemBase() {
        super(new Item.Properties());
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !XRPotionHelper.getPotionEffectsFromStack(stack).isEmpty();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack potion, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        XRPotionHelper.addPotionTooltip(potion, tooltip);
    }

    @Override
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (!this.m_41389_(group) || Boolean.TRUE.equals(Settings.COMMON.disable.disablePotions.get())) {
            return;
        }
        for (PotionEssence essence : PotionMap.uniquePotions) {
            ItemStack potion = new ItemStack((ItemLike)this, 1);
            XRPotionHelper.addPotionEffectsToStack(potion, essence.getEffects());
            items.add((Object)potion);
        }
    }

    @Override
    public List<MobEffectInstance> getEffects(ItemStack stack) {
        return XRPotionHelper.getPotionEffectsFromStack(stack);
    }
}

